# 表单属性域

# 表单上传

这是传统的 form 表单上传，使用 form 表单的 input[type=”file”]控件，可以打开系统的文件选择对话框，从而达到选择文件并上传的目的，它的好处是多浏览器兼容，它是 web 开发者最常用的一种文件上传方式。

表单的代码如下：

```html
<form method="post" action="http://uploadUrl" enctype="multipart/form-data">
  <input name="file" type="file" accept="image/gif,image.jpg" />
  <input name="token" type="hidden" />
  <input type="submit" value="提交" />
</form>
```

以下是表单上传几个关键点：

- method=”post”: 采用 post 方式提交数据
- enctype=”multipart/form- data”：采用 multipart 格式上传文件，此时 request 头会显示 Content-Type:multipart/form-data; boundary=—-WebKitFormBoundaryzr34cwJ67R95KQC9
- action：标明上传的服务端处理地址
- type=”file”：使用 input 的 file 控件上传
- 如果是多文件批量上传，可以将 input[type=”file”]的 name 属性设置为如：name=”file[]”
- accept 属性是 HTML5 的新属性，它规定了可通过文件上传提交的文件类型
- 上传的触发事件可以是：input[type=”file”]的 onChange 触发，也可以由一个独立的按钮的 onClick 使整个表单提交，此时还可以用 input[type=”hidden”]带一些其它的参数，比如 Token 来源验证等等。
